/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
#include <Dialog.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
//Dialog and control Ids
#define IDD_DIALOG1                     2000
#define IDC_DOTNET						543

//Exposed events from Control
#define	ON_INTEROP_CLICK(_idCntl, _ocFunc)	ON_ACTIVEX_EVENT(0x60020001, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4)
#define	ON_INTEROP_DBLCLICK(_idCntl, _ocFunc)	ON_ACTIVEX_EVENT(0x60020002, _idCntl, _ocFunc, VTS_CTRL VTS_I4 VTS_I4)



class CDotNetComInteropDlg : public Dialog
{
public:
	CDotNetComInteropDlg();

	EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	//Event handler entries for the exposed events
	ON_INTEROP_CLICK(IDC_DOTNET, OnClick)
	ON_INTEROP_DBLCLICK(IDC_DOTNET, OnDblClick)
	EVENTS_END
	
	BOOL OnClick(Control ctrl, int x, int y)
	{
		printf("Clicked at (%d,%d)\n", x,y);
		return true;
	}
	
	BOOL OnDblClick(Control ctrl, int x, int y)
	{
		printf("DblClicked at (%d,%d)\n", x,y);
		return true;
	}

	
	BOOL OnInitDialog();
	
	Control m_ctrlDotNet;
};



CDotNetComInteropDlg::CDotNetComInteropDlg()
	: Dialog(IDD_DIALOG1, "Release\\DialoBuilderResource.dll") // before running, need to open DotNet\SampleControl\SampleControl.sln to build dll in release mode
{
	InitMsgMap();
}


BOOL CDotNetComInteropDlg::OnInitDialog()
{
	//Control creation by GUID
	GUID guid = {0x4C69E367,0x43AF,0x4a1c, {0xB5,0xF0,0x44,0x7A,0x36,0xD1,0xDE,0x1B}};
	RECT rect = {20,20,200,200};
	if(m_ctrlDotNet.CreateActiveXControl(guid, WS_CHILD|WS_VISIBLE, rect, GetSafeHwnd(), IDC_DOTNET))
	{
		//Control intialization using the exposed interface of the DotNet control
		Object ctrlObj = m_ctrlDotNet.GetActiveXControl();
		ctrlObj.SetBorder(true);
	}
	return TRUE;
}

void Launch_CDotNetComInteropDlg()
{
	CDotNetComInteropDlg dlgDotNet;
	dlgDotNet.DoModal();
}

